<?php

namespace App\Http\Requests\Api;

use Illuminate\Foundation\Http\FormRequest;

class ProfileRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'owner_name' => ['sometimes' , 'string'],
            'email' => ['sometimes', 'email', 'unique:users,email,'.auth()->user()->id],
            'mobile' => ['sometimes', 'numeric'],
            'country_code' => ['sometimes', 'string'],

        ];
    }
}
