<?php

namespace App\Http\Requests\Api\Admin;

use App\Models\User;
use Illuminate\Validation\Rule;
use Illuminate\Foundation\Http\FormRequest;

class EmployeeRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Prepare the data for validation.
     */
    protected function prepareForValidation()
    {
        // Always set type to 'employee'
        $this->merge([
            'type' => 'employee', // Automatically set 'employee'
            'country_id' => User::find(request('vendor_id'))->country_id?? $this->country_id,
        ]);
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        $isUpdate = $this->isMethod('put') || $this->isMethod('patch');  // Check if it's an update request
        $id = $this->route('employee');

        $rules =  [
            'owner_name' => ['required', 'string', 'max:255'],
            'email' => ['required', 'email', 'unique:users,email'],
            'password' => ['required', 'confirmed', 'min:5,max:20'],
            'vendor_id' => ['required','exists:users,id'],
            'role_name' => ['required', 'string'],
            'branch_id' => ['required', 'exists:branches,id'],
            'type' => ['required', 'string', 'in:employee'], // Ensure 'type' is 'employee'
        ];

        if($isUpdate){
            $rules['owner_name'] = ['sometimes', 'string', 'max:255'];
            $rules['email'] = ['sometimes', 'email', Rule::unique('users', 'email')->ignore($id)];
            $rules['password'] = ['sometimes', 'confirmed', 'min:5,max:20'];
            $rules['vendor_id'] = ['sometimes','exists:users,id'];
            $rules['role_name'] = ['sometimes', 'string'];
            $rules['branch_id'] = ['sometimes', 'exists:branches,id'];
            $rules['type'] = ['sometimes', 'string', 'in:employee']; // Ensure 'type' is 'employee'

        }
        return $rules;
    }
}
