<?php

namespace App\Http\Controllers\Api;

use App\Models\City;
use App\Models\Country;
use App\Models\Setting;
use App\Models\Currency;
use App\Models\BankAccount;
use App\Models\Governerate;
use Illuminate\Http\Request;
use App\Traits\HasCrudActions;
use App\Http\Controllers\Controller;
use App\Http\Resources\CountryResource;
use App\Http\Resources\Api\CityResource;
use App\Http\Resources\CurrencyResource;
use App\Http\Resources\Api\GovernerateResource;
use App\Http\Resources\Api\Admin\SettingResource;

class SettingController extends Controller
{
    use HasCrudActions;


    public function countries()
    {
        return $this->apiResponse('200', __('success'), '', CountryResource::collection(Country::orderBy('id', 'DESC')->get()));
    }

    public function cities(Request $request)
    {
        return $this->apiResponse('200', __('success'), '',
            CityResource::collection(
                City::when($request->has('gov_id'), function($q) use($request) {
                    $q->where('governerate_id', $request->gov_id);
                })->orderBy('id', 'DESC')->get()
            )
        );
    }


    public function govers()
    {
        return $this->apiResponse('200', __('success'), '', GovernerateResource::collection(Governerate::orderBy('id', 'DESC')->get()));
    }


    public function currencies()
    {
        return $this->apiResponse('200', __('success'), '', CurrencyResource::collection(Currency::orderBy('id', 'DESC')->get()));
    }

    public function setting()
    {
        return $this->apiResponse('200', __('success'), '', SettingResource::collection(Setting::orderBy('id', 'DESC')->get()));

    }

    public function getBankData()
    {
        $bankdata = BankAccount::whereNotNull('admin_id')->select(['id','bank_account' , 'bank_holder_name' , 'bank_number' , 'swift_code' , 'iban'])->first();
        return $this->ApiResponse('200', __('success'),  __('success') , $bankdata);

    }
}
