<?php

namespace App\Http\Resources\Api\vendor;

use App\helpers\Attachment;
use App\Http\Resources\MediaResource;
use Carbon\Carbon;
use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;
use Spatie\MediaLibrary\MediaCollections\Models\Collections\MediaCollection;

class RfqResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'qty' => $this->qty,
            'status' => $this->status,
            'price' => Attachment::convertPrice($this->price),
            'isChecked' => $this->isChecked(),
            'created_at' => Carbon::parse($this->created_at)->format('y-m-d'),

            'product' => $this->whenLoaded('product', function () {
                return [
                    'id' => $this->product->id,
                    'name' => $this->product->name,
                    'image' => MediaResource::make($this->product->image), // Accessor for image
                ];
            }),
            'specs' => $this->whenLoaded('specs', function () {
                return $this->specs->map(function ($spec) {
                    return [
                        'id' => $spec->id,
                        'key' => $spec->key,
                        'value' => $spec->value,
                    ];
                });
            }),
            'branch' => $this->whenLoaded('branch', function () {
                return [
                    'id' => $this->branch->id,
                    'location' => $this->branch->location,
                ];
            }),
        ];
    }

}
