<?php

namespace App\Http\Resources\Api\vendor;

use Illuminate\Http\Request;
use App\Http\Resources\MediaResource;
use Illuminate\Http\Resources\Json\JsonResource;
use App\Http\Resources\Api\Dentist\ProductResource;

class CategoryResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id'=>$this->id,
            'name'=>$this->name,
            'image' => MediaResource::make($this->image),
            'products' => ProductResource::collection($this->whenLoaded('products')),
            'sub_categories' => SubCategoryResource::collection($this->whenLoaded('children'))
        ];
    }
}
