<?php

namespace App\Models;

use Carbon\Carbon;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Database\Eloquent\Model;
use Astrotomic\Translatable\Translatable;
use Astrotomic\Translatable\Contracts\Translatable as TranslatableContract;

class Country extends Model
{
    use Translatable;

	protected $table = 'countries';

	protected $fillable = [
		'code',
		'flag',
		'status',
		'is_default',
		'currency_symbol',
        'abbreviation'
	];

    public $translatedAttributes = [
		'name',
	];


	public function country_translations()
	{
		return $this->hasMany(CountryTranslation::class);
	}
}
