<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
      if (!Schema::hasTable('blogs')) {
        Schema::create('blogs', function (Blueprint $table) {
            $table->id();
            $table->enum('status' ,['active','inactive']);
            $table->timestamps();
        });
    }
    if (!Schema::hasTable('blogs_translations')) {
        Schema::create('blogs_translations', function (Blueprint $table) {
            $table->id();
            $table->foreignId('blog_id')->constrained('blogs')->cascadeOnDelete()->cascadeOnUpdate();
            $table->string('title');
            $table->text('description');
            $table->string('locale');
            $table->unique(['blog_id','locale']);
        });
    }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('blogs');
    }
};
