<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        if (!Schema::hasTable('pages')) {

        Schema::create('pages', function (Blueprint $table) {
            $table->id();
            $table->enum('status' ,['active','inactive']);
            $table->enum('location' ,['both','header','footer']);
            $table->boolean('is_mobile')->default(0);
            $table->timestamps();
        });
    }


    if (!Schema::hasTable('page_translations')) {
        Schema::create('page_translations', function (Blueprint $table) {
            $table->id();
            // $table->integer('page_id')->unsigned();
            $table->foreignId('page_id')->constrained('pages')->cascadeOnDelete()->cascadeOnUpdate();
            $table->string('locale');
            $table->string('title');
            $table->text('describtion');
            $table->unique(['page_id','locale']);
            // $table->foreign('page_id')->references('id')->on('pages')->onDelete('cascade');

      });
    }
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('pages');
    }
};
