<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\DB;

class PagesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // Insert the pages
        $pages = [
            ['status' => 'active', 'location' => 'both', 'is_mobile' => 0],
            ['status' => 'active', 'location' => 'both', 'is_mobile' => 0],
            ['status' => 'active', 'location' => 'both', 'is_mobile' => 0],
        ];

        // Insert the base pages
        DB::table('pages')->insert($pages);

        // Get the inserted pages' IDs
        $pageIds = DB::table('pages')->pluck('id');

        // Insert translations for the pages
        $translations = [
            // Translations for "About Us"
            ['page_id' => $pageIds[0], 'locale' => 'en', 'title' => 'About Us', 'describtion' => 'This is the About Us page.'],
            ['page_id' => $pageIds[0], 'locale' => 'ar', 'title' => 'معلومات عنا', 'describtion' => 'هذه هي صفحة معلومات عنا.'],

            // Translations for "Terms and Conditions"
            ['page_id' => $pageIds[1], 'locale' => 'en', 'title' => 'Terms and Conditions', 'describtion' => 'These are the terms and conditions.'],
            ['page_id' => $pageIds[1], 'locale' => 'ar', 'title' => 'الشروط والأحكام', 'describtion' => 'هذه هي الشروط والأحكام.'],

            // Translations for "Privacy Policy"
            ['page_id' => $pageIds[2], 'locale' => 'en', 'title' => 'Privacy Policy', 'describtion' => 'This is the privacy policy page.'],
            ['page_id' => $pageIds[2], 'locale' => 'ar', 'title' => 'سياسة الخصوصية', 'describtion' => 'هذه هي صفحة سياسة الخصوصية.'],
        ];

        // Insert translations
        DB::table('page_translations')->insert($translations);
    }
}
