<?php

namespace App\Http\Controllers\Api\Admin;

use App\Models\RFQ;
use Illuminate\Http\Request;
use App\Traits\HasCrudActions;
use App\Http\Controllers\Controller;
use App\Http\Resources\Api\Admin\RfqResource;
use Symfony\Component\HttpFoundation\Response;

class RfqController extends Controller
{
    use HasCrudActions;


    protected $model = RFQ::class;

    protected $resource = RfqResource::class;


    public function index(Request $request)
    {
        $model = app($this->model);

        // Use the method to retrieve relations for eager loading
        $searchableFields = [
            'user' => ['owner_name' => $request->user],
            'vendor' => ['owner_name' => $request->vendor],

        ];

        $modelResource = $this->search()
        ->when($request->has('date'), function($q) use ($request) {
            $q->whereDate('created_at', $request->date);
        })
        ->where(['status' => 'pending', 'order_type' => 'rfq_order' , 'vendor_id' => null])
        ->searchRelated($searchableFields)
        ->with([
            'product:id,name',
            'specs:id,key,value',
            'branch:id,name,location,city_id',
            'user:id,owner_name',
        ]);


        return $this->paginatedResponse($modelResource->orderBy('id', 'DESC') , $this->resource);
    }

    public function show(string $id)
    {
        $record = $this->model::find($id);

        if (!$record) {
            return $this->apiResponse(Response::HTTP_OK, 'fail', __('resource not found'));
        }
        $relations = method_exists($record, 'getWithRelations') ? $record->getWithRelations() : [];

        $recordResource = new $this->resource($record->load([
            'product:id,name',
            'specs:id,key,value',
            'branch:id,name,location,city_id',
            'user:id,owner_name',
        ]));

        return $this->apiResponse(Response::HTTP_OK, __('success'), '', $recordResource);
    }

}
